package com.digiwin.athena.mechanism.dto;

import lombok.Data;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * @Description 查询机制API的请求实
 * @Author liugl
 * @Date 2024/6/26 9:13
 **/
@Data
public class MechanismApiInfoDTO {
	/**
	 * api，ESP的serviceId或者是内部方法名称
	 */
	private String api;

	/**
	 * 是否需要通过esp调用方法
	 */
	private Boolean isNeedEsp;

	/**
	 * 机制能力类型
	 */
	private String abilityType;

	/**
	 * 限制判断条件
	 */
	private String limitConditionType;

	/**
	 * 限制执行条件
	 */
	private String limitActionType;

	/**
	 * 绑定内容
	 */
	private BindingContext context;
	/**
	 * 请求入参
	 */
	private Object requestJson;

	/**
	 * 表格数据
	 */
	private Object tableData;

	/**
	 * 开窗内部数据信息{字段名，字段内部开窗actionId}
	 */
	private Map<String, String> openWindow;

	/**
	 * 机制能力
	 */
	private Object ability;

	/**
	 * 判断表格数据唯一性的字段名集合 默认是bk_info
	 */
	private LinkedList<String> keyFieldNameList = new LinkedList(Arrays.asList("bk_info"));

	/**
	 * 操作类型 限制能力多层级时使用数组，第一个参数是第一层，第二个参数是第二层
	 */
	private List<String> operationTypes;
}
