package com.digiwin.athena.mechanism.widgets.condition;

import lombok.Getter;

@Getter
public enum OnTimeCheckUnit {

    MINUTE(60 * 1000L),

    HOUR(3600 * 1000L),

    DAY(24 * 3600 * 1000L),

    WEEK(7 * 24 * 3600 * 1000L),

    MONTH(30L * 24L * 3600L * 1000L);

    private final long factor;

    OnTimeCheckUnit(long factor) {
        this.factor = factor;
    }
}
