package com.digiwin.athena.mechanism.widgets.condition;

import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.process.FilterCondition;
import com.digiwin.athena.domain.core.process.ModelSelObj;
import com.digiwin.athena.domain.core.process.ProcessConfigLink;
import com.digiwin.athena.dto.MultiLanguageDTO;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

@Setter
@Getter
@Document(collection = "processConditions")
public class ProcessConditions extends TenantObject {

    private String processId;

    private String processName;

    private String conditionStartId;

    private String conditionStartName;

    private List<Map<String, Object>> conditionList;
    // UI模式下存贮的信息
    private List<FilterCondition> queryConditions;

    private String type;

    // 编译后的条件表达式
    private String conditionExpression;

    // 编译后的条件表达式-对应的变量引用关系
    private Map<String, String> conditionVariableMap;

    // 条件节点选择的筛选模式  脚本模式与UI模型
    private String conditionMode;

    private String linkId;
    /**
     * 用于解析条件表达式
     */
    private ModelSelObj modelSelObj;
    /**
     * 交付设计器是否生效过，用于交付设计器展示
     */
    private boolean isDesigner;

    /**
     * 启用交付设计器开关
     */
    private Boolean allowInteractiveFlag;

    /**
     * 其他条件分支
     */
    private Boolean isOther;

    /**
     *
     */
    private ProcessConfigLink link;

}
