package com.digiwin.athena.set.part;

import lombok.Data;

/**
 * @title: ReturnField
 * @author: linc
 * @date 2023/10/14 16:05
 * @version: 1.0
 */
@Data
public class ReturnField {
    private String datasourceField;

    private String displayName;

    private boolean editable;

    private boolean hide;

    private String valueType;

    private String type;

    public String getDataDescriptionFieldType() {
        //页面类型转dataDescription中fields的dataType
        String dataType = "STRING";
        //页面类型转action定义中的dataType
        switch (valueType) {
            case "string":
            case "text":
                dataType= "STRING";
                break;
            case "number":
            case "numeric":
            case "percent":
                dataType= "DOUBLE";
                break;
            case "boolean":
                dataType= "BOOLEAN";
                break;
        }
        return dataType;

    }
    public String getDataFieldDataType() {
        String dataType = "string";
        //页面类型转action定义中的dataType
        switch (valueType) {
            case "string":
            case "text":
                dataType= "string";
                break;
            case "number":
            case "numeric":
            case "percent":
                dataType= "number";
                break;
            case "boolean":
                dataType= "boolean";
                break;
        }
        return dataType;
    }
}
