package com.digiwin.athena.deploy;

import lombok.Data;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class DeployTask {

    private String id;
    private String appId;
    private String appName;
    private String sourceId;
    private String deployId;
    private String eventId;
    private String fileId;
    //app公共应用 tenantApp个案发布 tenantCustom租户级发布
    private String type;


    //如果不为空表示单作业发布
    private List<JobRecord> jobList;

    private Date createTime;
    private Long updateTime;
    private Date beginTime;
    private Date endTime;
    private Long cost;

    //0新建 1进行中 2已完成 3失败  4撤回 5告警
    private Integer status;

    private Integer processCount;

    private String msg;

    private String version;

    private Map<String,List<String>> cleanSourceTenants;

    private Boolean updateEspVersion;
    private Boolean commonApp;

    private List<String> subDeployIds;
    private List<String> subEventIds;
    private String parentEventId;
    private String token;
    private String routerKey;

    //个案是否全部拷贝，true表示除了基础资料和报表，其他只查询个案
    private Boolean individualAll;
    //本次发版租户
    private List<String> tenantIds;
    private Map<String,String> tenantIdNames;
    //上一次个案的租户
    private List<String> lastIndividualTenantIds;
    //这一次被删除的
    private List<String> individualRemovedTenantIds;
    //这一次新增的
    private List<String> individualAddedTenantIds;
    //这一次保留的
    private List<String> individualKeepTenantIds;

}
