package com.digiwin.athena.domain.core;


import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.domain.definition.features.Condition;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.util.List;


@Getter
@Setter
public class DataState extends TenantObject {

    /**
     * 数据描述【dataDescription】code
     */
    private String dataCode;
    /**
     * 项目code
     */
    private String projectCode;
    /**
     * 从哪个状态派生而来
     */
    private String parentStateCode;
    /**
     * 该种数据状态额外的数据结构
     */
    private List<FieldDescription> extendFields;
    /**
     * 是否组合型状态
     */
    private Boolean isComposite;
    /**
     * 条件判断表达式
     */
    private Condition condition;
    /**
     * 数据特征集，保存的是数据特征表【dataFeatureSet】的主键code
     */
    private List<String> dataFeatureSets;
    /**
     * 流程变量
     */
    private List<JSONObject> variables;

    @Override
    public boolean equals(Object other){
       if(other instanceof DataState){
           DataState oth = (DataState) other;
           return this.getCode().equals(oth.getCode());
       }

        return false;
    }

//    @Override
//    public int compareTo(DataState o) {
//        return   o.getPriority()-this.getPriority();
//    }
}
