package com.digiwin.athena.domain.core;


import com.digiwin.athena.domain.definition.TaskRef;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
项目里程碑的阶段,包含若干任务,用于展示 需求#4297
 **/
@Getter
@Setter
public class Phase extends Execution{

    //
    private String type;
    @Deprecated
    private List<TaskRef> tasks;

    private List<String> taskCodes;

    private List<String> inputStates;
    private Boolean isHideKey;

    /**
     * 隐藏的任务
     */
    private List<String> hideTaskCodes;


    public Phase(){}
    public Phase(String code, String name, Map<String, Map<String,String>> lang, String... taskCodes) {
        this.setCode(code);
        this.setName(name);
        this.setLang(lang);
        this.taskCodes = new ArrayList<>(Arrays.asList(taskCodes));
    }




}
