package com.digiwin.athena.domain.core.dtdflow;


import com.digiwin.athena.domain.common.TenantObject;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

@Getter
@Setter
@Document(collection = "eventTemplate")
public class EventTemplate extends TenantObject {

    /**
     * 事件id
     */
    private String eventId;
    /**
     * 事件名称
     */
    private String eventName;
    /**
     * 事件等级
     */
    private String eventLevel;
    /**
     * 事件类型
     */
    private String eventType;
    /**
     * 事件拥有者
     */
    private String eventOwner;
    /**
     * 事件主体
     */
    private Object eventBodyExplain;
    private String eventEnable;

    /**
     * 事件订阅者
     */
    private List<EventSubcribe> subscribes;
}
