package com.digiwin.athena.kg.domain;


import com.digiwin.athena.domain.common.TenantObject;
import lombok.Data;

import java.util.List;

/**
 * @title: ApplicationCustomizedConfig
 * @author: linc
 * @date 2023/8/31 9:00
 * @version: 1.0
 * 应用客制插件配置
 */
@Data
public class ApplicationCustomizedConfig extends TenantObject {
    /**
     * 所属应用id
     */
    private String appId;


    /**
     * 定制包路径
     */
    private String path;

    /**
     * 定制包打包后的chunk名称
     */
    private String chunkName;

    /**
     * 是否是微前端
     */
    private Boolean isMF;

    /**
     * 微前端中被导出的模块名称
     */
    private String remoteName;

    /**
     * 微前端中被导出的模块路径
     */
    private String exposedModule;

    /**
     * 配置类型：公有system/私有private
     */
    private String type;

    /**
     * 关联的应用id
     */
    private List<String> relationAppIds;

    public String entityBizCode() {
        return appId + chunkName;
    }

}
