package com.digiwin.athena.kg.domain;

import com.digiwin.athena.domain.common.HierarchicalEntity;
import lombok.Data;
import org.neo4j.ogm.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * d 数据定义维度,
 * 0 系统级, 不根据租户改变
 * 1 lazy级别,修改时创建新节点
 * 2 租户级. 租户级表示租户初始化时/订购时 必须创建该节点
 **/
@NodeEntity
@Data
public class DomainEntity extends HierarchicalEntity {

    @Id
    @GeneratedValue
    private Long neo4jId;

    private String id;

    //节点版本号
    private String version;
    //0系统级, 1lazy级别 2租户级
    private Integer d;

    //特性,trait=1表示该节点是个抽象节点,需要查找该节点的IMPL节点
    private Integer trait;
    @Relationship(type="IMPL")
    private List<DomainEntity> impl;

    @Properties
    private Map<String,Object> properties;

//    @Properties
//    private Map<String,Map<String,String>> lang;
    //为了兼容
//    @Properties
//    private Map<String,Map<String,String>> language;
}
