package com.digiwin.athena.kg.monitorRule;


import com.digiwin.athena.kg.monitorRule.tenant.DynamicParamsDO;
import com.digiwin.athena.kg.monitorRule.tenant.ProductTypeEnum;
import com.digiwin.athena.kg.monitorRule.tenant.TenantDynamicConditionDO;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;


@Data
@Document(collection = "monitorRuleTenantConfig")
public class MonitorRuleTenantConfig extends MonitorRuleConfig{


    private String productName;

    private TenantDynamicConditionDO dynamicCondition;

    private ProductTypeEnum type;

    private Integer status;

    private Object standardPollingRule;

//    private Object apiSetting;
//
//    private Object timeSetting;
    private List<DynamicParamsDO> dynamicParams;

    private EocMapDTO eocMap;

    //用于记录最新更新的操作
    private String transactionId;

    private String backtrackDate;

    //支持多个排程日期
    private Object standardPollingRules;

    //存储过程名称以及参数配置
    private String procedure_name;
    private List<ProcedureParam> procedure_input;

    //是否需要去重，默认false.当设置true时必须配置bk_info
    private Boolean is_deduplication;
    private BkInfo2 bk_info;

    private Integer beforeClosedStatus;
    private Boolean closed;
    private String script;

}
