package com.digiwin.athena.mechanism.bo;



import com.digiwin.athena.domain.common.BaseObject;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;


@Data
@Accessors(chain = true)
@Document(collection = "mechanismApiInfo")
public class MechanismApiInfoBO extends BaseObject {

    /**
     * 零件code
     */
    private String code;
    /**
     * api名称
     */
    private String name;
    /**
     * 机制能力类型
     */
    private String type;
    /**
     * 是否包含决策方案
     */
    private Boolean hasScheme;
    /**
     * 决策方案名称
     */
    private String schemeName;
    /**
     * 服务
     */
    private String serviceId;

    /**
     * 请求参数
     */
    private Object requestJson;

}
