package com.digiwin.athena.mechanism.dto;

import com.digiwin.athena.mechanism.common.JsExpressionType;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-27 13:30
 **/
@Data
public class BindingContext {

    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 机制code
     */
    private String mechanismCode;
    /**
     * 机制原理code
     */
    private String principleCode;
    /**
     * 组件code
     */
    private String componentCode;
    /**
     * 插件ID 一般为机制能力code
     */
    private String pluginId;
    /**
     * 应用ID
     */
    private String application;
    /**
     * 传入参数
     */
    private Map<String,Object> param = new HashMap<>();
    /**
     * 返回结果
     */
    private Object result;
    /**
     * 机制变量
     */
    private Map<String,Object> mechanismVariables = new HashMap<>();
    /**
     * 表达式类型
     */
    private JsExpressionType jsExpressionType;
}
