package com.digiwin.athena.kg.activity;

import com.digiwin.athena.kg.domain.FieldOpenWindowSetting;
import com.digiwin.athena.kg.domain.OpenWindowDefinition;
import lombok.Data;
import org.springframework.data.neo4j.annotation.QueryResult;

import java.util.List;
import java.util.Map;

@Data
@QueryResult
public class ActivityBaseInfoVO {
    private String taskId;
    private Boolean allowSubLevel = false;
    private Boolean needEnableApprove = true;
    private Integer sequence;
    private List<Map<Object,Object>> subApprove;
    private List<FieldOpenWindowSetting> fieldOpenWindowMap;
    // 动态条件对应开窗信息(通过fieldOpenWindowMap查询)
    private Map<String, OpenWindowDefinition> fieldOpenWindowDefinitions;
    private Object fieldMappings;
    private String taskName;
    private String activityId;
    private String activityName;
    private String startApproveActivityName;
    private String approvePlanDesc;
    private String activityVersion;
    private Map<String, Object> config;
    private Boolean manualAble;
    private String mainLineTaskId;
    private String authorityPrefix;
}
