package com.digiwin.athena.kg.report.hz.model.modelCenterMetaData;


import lombok.Data;

import java.util.List;

/**
 * @title: DataModelDTO
 * @author: linc
 * @date 2023/12/21 9:45
 * @version: 1.0
 */
@Data
public class DataModelDTO {
    /**
     * 绑定api
     */
    private String apiId;
    /**
     * 模型code
     */
    private String code;
    /**
     * 模型描述
     */
    private String comment;
    private List<DomainDTO> domains;
    /**
     * 数据源主键
     */
    private Long dsId;
    /**
     * 主键
     */
    private Long id;
    private List<ModelLinkDTO> links;
    /**
     * 前端元数据，前端存储表位置信息
     */
    private String meta;
    /**
     * 多租户标识键，是否启用多租户,1:启用,0:不启用
     */
    private String multiTenant;
    /**
     * 模型名称
     */
    private String name;
    /**
     * 强关联，是否开启强关联(对象模型)的字段, 0:否, 1:是
     */
    private String strongRelationship;
    private List<ModelTableDTO> tables;
    /**
     * 模型类型，1：普通模型，2：可引用模型
     */
    private String type;
}
