package com.digiwin.athena.kg.struct;

import lombok.Data;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;

/**
数据的检测规则,key支持如下
 required 必填校验
 max 最大值校验
 min 最小值
 maxLength 最大字符串长度
 minLength 最小字符串长度
 scala 小数位数
 readonly 只读
 hidden 隐藏
 pattern 正则表达式 对应value为正则表达式
 expression 表达式校验 对应value为脚本
 server 服务器端校验
 样例:{ "key": "server", "condition": "true", "serverUrl": "http://xxx.com/api/xxx" }
 服务器返回值:{ "success": true, "message": "名字唯一" }或者{ "success": false, "message": "用户名称不唯一" }

 **/
@Data
public class DataCheckRule {

    @Id
    @GeneratedValue
    private Long neo4jId;

    //检测的key,
    private String key;
    //校验的条件,默认是true
    private String condition="true";
    //值
    private Object value;
    //错误描述
    private String errorMessage;
    //通知类型 alert notify notice
    private String alertType;
    //通知级别 error warn info
    private String alertLevel;

}
