package com.digiwin.athena.domain.component.bo;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

@Data
@Document(collection = "tenantAppComponentList")
@CompoundIndexes({@CompoundIndex(name="key_idx", def="{'appCode':1, 'tenantId':1}", unique=true)})
public class TenantAppComponentListBO {

    @Id
    private String uid;

    //应用编号，同时也是管理议题编号
    private String appCode;
    //租户id
    private String tenantId;
    //组件清单
    List<ComponentBO> components;
}
