package com.digiwin.athena.domain.core.app;

import com.digiwin.athena.domain.common.BaseObject;
import com.digiwin.athena.domain.common.ParamApi;
import com.digiwin.athena.domain.common.Tag;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.definition.FieldDescription;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class Application extends TenantObject {
    /**
     * 标签集合 适用的场景/行业
     */
    private List<Tag> tags;
    /**
     * 应用的参数
     */
    private List<FieldDescription> paramDescription;

    /**
     * 参数来源api
     */
    private List<ParamApi> paramApi;

    /**
     * 应用的清单
     */
    private List<FieldDescription> manifest;

    /**
     * 应用类型 增强型应用enhance
     */
    private String category;

    /**
     * 应用扩展类型 增强型应用数字员工为 digitalStaff
     */
    private String extendType;

    /**
     * 应用扩展数据 增强型应用数字员工为 数字员工code
     */
    private String extendData;

    /**
     * 应用扩展数据 增强型应用数字员工为 数字员工名称
     */
    private String extendDisplay;
    /**
     * 应用的其他特征信息 userIntegrityCheck
     */
    private Map<String, Object> feature;
    /**
     * 通过扩展信息配置参数。例如项目卡，任务卡是否支持自定义，用于项目任务要素设定
     */
    private FunctionCtrl functionCtrl;

    /**
     * 是否公共应用
     */
    private Boolean commonApp;
    /**
     * 应用来源
     */
    private String source;

    /**
     * 敏捷数据 应用计费类型和计费商品id
     */
    private String payType; //  payPerView 按次
    /**
     * // 计费商品id
     */
    private String billingGoodsId;
    /**
     * 是否个案
     */
    private Boolean individual;
    /**
     * 个案是否全部拷贝，true表示除了基础资料和报表，其他只查询个案
     */
    private Boolean individualAll;


    /**
     * 创建者
     */
    private Object createBy;

    /**
     * 创建时间
     */
    private Long createDate;

    /**
     * 修改者
     */
    private Object editBy;

    /**
     * 修改时间
     */
    private Long editDate;

    private List<String> productLines;
    /**
     * 应用类型，数据驱动（1.0）：1，模型驱动（2.0）：5
     */
    private Integer appType;


}