package com.digiwin.athena.domain.core.process;

import lombok.Data;

import java.util.List;

/**
 * @description: 数据的筛选对象
 * @author: wangyan
 * @date: 2023/11/7 11:54
 */
@Data
public class FilterCondition {

    // 顺序，第几个条件
    private int order;

    // 表名
    private String search_table_path;

    // 字段
    private String search_field;

    // 操作类型  equal
    private String search_operator;

    // 如果是数字就是字符串类型的，所以使用object接收
    private List<Object> search_value;

    // 括号
    private String bracket;

    // AND / OR
    private String logic;

    // 筛选条件的value模型 CUSTOM_CONSTANT 自定义模式  GENERAL正常模式
    private String mode;
}