package com.digiwin.athena.domain.core.process;

import com.digiwin.athena.dto.MultiLanguageDTO;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Field;

import java.util.Map;

@Data
public class ProcessConfigLink {

    @Field("id")
    private String id;
    //线段说明
    private String text;
    private String fromId;
    private String toId;
    private Integer sort;
    private Map<String, MultiLanguageDTO> lang;
    private String conditionType;

    // 编译后的条件表达式
    private String conditionExpression;

    // 编译后的条件表达式-对应的变量引用关系
    private Map<String, String> conditionVariableMap;


    /**
     * 默认勾选，勾选后即开启数据分组，禁止取消勾选
     */
    private Boolean openDataGroup;

    /**
     * 在openDataGroup打开时候展示，默认不勾选, checkbox发送空的任务卡
     */
    private Boolean sendBlankCard;


}
