package com.digiwin.athena.dto;


import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class BasicQuery {

    /**
     * 当前页码
     */
    private Integer page;
    /**
     * 每页条数
     */
    private Integer pageSize;
    /**
     * 返回字段
     */
    private List<String> returnFields;
    /**
     * 排序字段
     */
    private List<SortField> sortFields;
    /**
     * 查询条件
     */
    private Map<String, Object> query;

    private BaseCondition condition;
    /**
     * 运营单元信息
     */
    private Map<String, Object> eocInfo;
    /**
     * 主键
     */
    private Object id;
    /**
     * 主键列表
     */
    private List ids;

    private Map<String,Object> data;


    public static BasicQuery of(Map<String, Object> query, Map<String, Object> eocInfo) {
        BasicQuery basicQuery = new BasicQuery();
        basicQuery.setQuery(query);
        basicQuery.setEocInfo(eocInfo);
        return basicQuery;
    }
}
