package com.digiwin.athena.kg.authority;


import lombok.Data;

import java.util.List;

@Data
public class AuthorityConfigVO {
    /**
     * 应用信息
     */
    private AppVO app;
    /**
     * 应用类型
     */
    private String type;
    /**
     * 应用token
     */
    private String appToken;
    /**
     * 模块列表
     */
    private List<ModuleVO> modules;
    /**
     * 动作列表
     */
    private List<ActionVO> actions;
    /**
     * 限制的租戶列表
     */
    private List<String> limitedTenantIdList;
    /**
     * 排除的租戶列表
     */
    private List<String> excludedTenantIdList;

    /**
     * 租戶ID
     */
    private String tenantId;
    /**
     * 应用id
     */
    private String appId;
    /**
     * orgId, ruleId, userId 只有其中一個會有值
     * 组织id
     */
    private String orgId;
    /**
     * orgId, ruleId, userId 只有其中一個會有值
     * 角色ID
     */
    private String ruleId;
    /**
     * orgId, ruleId, userId 只有其中一個會有值
     * 用戶ID
     */
    private String userId;
}
