package com.digiwin.athena.kg.report.hz.model.modelCenterMetaData;

/**
 * @title: UnionType
 * @author: linc
 * @date 2023/12/21 11:20
 * @version: 1.0
 */

import java.io.IOException;

/**
 * 表关联类型
 */
public enum UnionType {
    INNER, LEFT, RIGHT;

    public String toValue() {
        switch (this) {
            case INNER: return "inner";
            case LEFT: return "left";
            case RIGHT: return "right";
        }
        return null;
    }

    public static UnionType forValue(String value) throws IOException {
        if (value.equals("inner")) return INNER;
        if (value.equals("left")) return LEFT;
        if (value.equals("right")) return RIGHT;
        throw new IOException("Cannot deserialize UnionType");
    }
}
