package com.digiwin.athena.set.part;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author QinQiang
 * @Description
 * @Date 2024/3/7
 **/
@Getter
public enum EmailNoticeTimingEnum {
    TASK_BEGIN("taskBegin", "任务开始"),
    TASK_END("taskEnd", "任务结束"),
    PROJECT_BEGIN("projectBegin", "项目开始"),
    PROJECT_END("projectEnd", "项目完结");

    private final String code;
    private final String desc;

    private static final Map<String, EmailNoticeTimingEnum> codeMap = new HashMap<>();

    static {
        for (EmailNoticeTimingEnum e : EmailNoticeTimingEnum.values()) {
            codeMap.put(e.code, e);
        }
    }

    EmailNoticeTimingEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EmailNoticeTimingEnum getByCode(String code) {
        return codeMap.get(code);
    }

}
