package com.digiwin.athena.set.part;

import com.digiwin.athena.domain.core.approve.ApproveInfo;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.times.TimeDefinition;
import lombok.Data;

import java.util.List;

/**
 * @title: APart
 * @description: APart
 * @author: linc
 * @date 2023/8/14 17:39
 * @version: 1.0
 */
@Data
public class TaskCardPart extends Part {
    public String template;
    public String taskName;
    public List<PageViewDESC> pageViewDESC;
    //当责者 项目卡用
    private Processor personIncharge;
    //执行者 任务卡用
    private Processor processor;
    //签核人 签核卡用
    private ApproveInfo approve;
    //回写api  自动任务用
    private String serviceName;
    private String actionId;
    // 产品名称
    private String productName;

    private List<Processor> params;

    private List<ReturnField> returnFields;

    /**
     * 任务卡、项目卡页面定义
     */
    private List<PageView> pageViews;
    /**
     * 预完日
     */
    private TimeDefinition dueDate;
    /**
     * 邮件通知
     */
    private List<EmailNotice> emailNotices;
    /**
     * 是否启用邮件通知
     */
    private Boolean enableEmailNotice;
}
