package com.digiwin.athena.domain.core;



import com.digiwin.athena.domain.definition.UserDefinition;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * type活动类型:
 http
 esp
 action 执行引擎
 serviceComposer 服务编排
 script
 createData
 composite
 invokeProject
 invokeTask
 invokeFlow
 taskEvent //推送任务事件,会
 manual
 approve
 wait //一直等待
 stopProject
 notice


 **/
@Getter
@Setter
public class Activity extends Execution {

    /**
     * 活动类型
     */
    private String type;

    /**
     * 是否是里程碑
     */
    private Boolean milestone;

    /**
     * 业务类型，参见ActivityPatternEnum:  NONE,BUSINESS,ADJUSTMENT,MECHANISM;
     */
    private String pattern;

    /**
     * 业务执行人
     */
    private List<UserDefinition> dynamicExecutors;

}
