package com.digiwin.athena.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

@Data
public class CommonActionVo {
    private String actionId;
    private String actionName;
    private String type;//sd调用时判断的类型
    private String label;//themeMap类型，同innerType
    private String labelName;//themeMap类型，同innerType
    private String serviceName;
    private String serviceVersion;
    private String url;
    private String method;
    private String allocateType;
    private String invokeType;//调用方式
    private String expression;
    private String target;

    private String dataEventId;
    private Boolean split;
    private String subject;
    @JSONField(name = "isServiceComposition")
    @JsonProperty("isServiceComposition")
    private boolean isServiceComposition;

    private String processId;
    private String taskId;
    private int emergency = 50;

    private String serviceComposerId;
    private Boolean asyncComplete;

    private String variableName;//机制变量名
    //private String code;//机制变量的code
    private String variableValue;//机制变量的值

    private String ruleId;
    private String ruleName;
    private TransformActionRule transRule;
    private String tenant;


    private List<ApiDataFieldMetadataDTO> request_parameters;
    private ApiDataFieldMetadataDTO response_object;
    private String request_parametersStr;
    //展平结构
    private List<ApiDataFieldMetadataDTO> request_parameters_flat;
    private List<ApiDataFieldMetadataDTO> response_parameters_flat;
    private String application;
    private List<ActionFieldRelation> actionFieldRelations;
    // 项目code，为了编译时生成monitorRuleAdapter
    private String projectCode;
}
