package com.digiwin.athena.mechanism.widgets.config;

import com.digiwin.athena.mechanism.bo.MechanismApiInfoBO;
import com.digiwin.athena.mechanism.bo.MechanismFunctionBO;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import lombok.Data;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-30 15:45
 **/
@Data
public class MechanismConditionConfig {
    /**
     * primary 基础条件   highGrade高级条件   api 半定制API
     */
    private String type;
    private String limitType;
    private MechanismVariable left;
    private MechanismVariable right;
    // eq gt lt gte lte between
    private String opType;
    //枚举 1:固定值，2机制参数
    private  Integer conditionValueType;
    //机制参数code码
    private String variableCode;
    /**
     * api条件实体类
     */
    private MechanismApiInfoBO mechanismApiInfo;
    /**
     * 字段控件类型  selector，numeric ，openWindow
     */
    private String metaFieldType;
    /**
     * 右侧判断条件类型
     * enum：枚举值  customValue：自定义值 mechanismVariable：机制参数
     * customFunction：自定义函数（高级条件中） task：任务字段
     */
    private String rightCondType;

    /**
     * 开窗数据对应的服务
     */
    private String openWindowActionId;
    /**
     * 提示语信息
     */
    private String limitTip;

    /**
     * 机制自定义函数
     */
    private MechanismFunctionBO mechanismFunction;

}
