package com.digiwin.athena.domain.core.flow;


import com.digiwin.athena.domain.common.TenantObject;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;

/**
任务流
 **/
@Getter
@Setter
public class FlowGraph extends TenantObject {

    /**
     * 任务流节点
     */
    private List<FlowNode> nodes;
    /**
     * 任务流关联关系
     */
    private List<FlowLink> links;

    /**
     * 任务流开始节点
     */
    private String startNodeId;
    /**
     * 任务流结束节点
     */
    private String endNodeId;
    /**
     * 任务流结束节点（机制专用，运行到机制某个状态就需要结束整个流程，就会走这个结束节点）
     */
    private String nooutEndNodeId;

    public static FlowGraph simple(String code,String activityCode){
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setCode(code);
        flowGraph.setTenantId("SYSTEM");
        flowGraph.setVersion("1.0");
        flowGraph.setLinks(new ArrayList<>());
        flowGraph.setNodes(new ArrayList<>());

        FlowNode start = new FlowNode();
        start.setId("start");
        start.setType("start");
        flowGraph.getNodes().add(start);
        FlowNode endNode = new FlowNode();
        endNode.setId("end");
        endNode.setType("end");
        flowGraph.getNodes().add(endNode);
        FlowNode activity = new FlowNode();
        activity.setId("activity01");
        activity.setType("activity");
        activity.setActivityCode(activityCode);
        flowGraph.getNodes().add(activity);

        FlowLink link1 = new FlowLink();
        link1.setFrom("start");
        link1.setTo("activity01");
        flowGraph.getLinks().add(link1);
        FlowLink link2 = new FlowLink();
        link2.setFrom("activity01");
        link2.setTo("end");
        flowGraph.getLinks().add(link2);


        return flowGraph;
    }

    public static FlowGraph basic(String code){
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setCode(code);
        flowGraph.setTenantId("SYSTEM");
        flowGraph.setVersion("1.0");
        flowGraph.setLinks(new ArrayList<>());
        flowGraph.setNodes(new ArrayList<>());

        FlowNode start = new FlowNode();
        start.setId("start");
        start.setType("start");
        flowGraph.getNodes().add(start);
        FlowNode endNode = new FlowNode();
        endNode.setId("end1");
        endNode.setDataKey("end1");
        endNode.setType("end");
        flowGraph.getNodes().add(endNode);

        return flowGraph;
    }


    public String findStartNodeId(){
        if(null!=this.getStartNodeId()){return this.getStartNodeId();}
        for(FlowNode node : this.getNodes()){
            if("start".equalsIgnoreCase(node.getType())){
                this.setStartNodeId(node.getId());
                return node.getId();
            }
        }
        return null;
    }

    public String findEndNodeId(){
        if(null!=this.getEndNodeId()){return this.getEndNodeId();}
        for(FlowNode node : this.getNodes()){
            if("end".equalsIgnoreCase(node.getType())){
                this.setEndNodeId(node.getId());
                return node.getId();
            }
        }
        return null;
    }

}
