package com.digiwin.athena.kg.struct;

import lombok.Data;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Properties;

import java.util.Map;

/**
 *某个字段的数据获取规则,支持表达式 / action中获取 /custom自行处理
 **/
@Data
public class DataRetrieveRule {

    @Id
    @GeneratedValue
    private Long neo4jId;

    //expression action custom
    private String type;
    //表达式,js执行,可能需要有上下文
    private String expression;
    //从指定请求中获取数据
    private String url;
    private String method;
    @Properties
    private Map<String,String> headers;
    @Properties
    private Map<String,String> params;
    //返回数据的路径,返回数据是一个json,可通过jsoup这样的方式获取,如果为空表示获取所有返回数据
    private String dataPath;

}
