/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.mechanism.common;

import java.util.Arrays;
import java.util.Optional;

public interface MechanismEnum {

    public static enum LimitTaskExecuteType {
        REQUIRED("required", "\u5fc5\u586b", "checkValid"),
        HIDDEN("hidden", "\u9690\u85cf", ""),
        DISABLED("disabled", "\u53ea\u8bfb", ""),
        SCOPE_LIMIT("scopeLimit", "\u53ef\u7f16\u8f91\u8303\u56f4", "checkValid");

        private String code;
        private String name;
        private String componentType;

        private LimitTaskExecuteType(String code, String name, String componentType) {
            this.code = code;
            this.name = name;
            this.componentType = componentType;
        }

        public static String getComponentType(String code) {
            LimitTaskExecuteType[] values = LimitTaskExecuteType.values();
            Optional<LimitTaskExecuteType> firstOptional = Arrays.stream(values).filter(v -> v.getCode().equalsIgnoreCase(code)).findFirst();
            if (firstOptional.isPresent()) {
                LimitTaskExecuteType limitTaskExecuteType = firstOptional.get();
                return limitTaskExecuteType.getComponentType();
            }
            return "";
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public void setComponentType(String componentType) {
            this.componentType = componentType;
        }
    }

    public static enum LimitActionType {
        REMINDER("reminder", "\u63d0\u9192"),
        LIMIT_ACTION("limitAction", "\u9650\u5236\u884c\u52a8"),
        AUTO_PROCESS("autoProcess", "\u81ea\u52a8\u5904\u7406");

        private String code;
        private String name;

        private LimitActionType(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum PersonnelConditionType {
        PROFICIENCY("proficiency", "\u719f\u7ec3\u5ea6"),
        DUTY("duty", "\u804c\u80fd"),
        STAFF("staff", "\u4eba\u5458");

        private String code;
        private String name;

        private PersonnelConditionType(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum LimitConditionType {
        BUSINESS("businessCondition", "\u4e1a\u52a1\u6761\u4ef6"),
        PERSONNEL("personnelCondition", "\u4eba\u5458\u6761\u4ef6");

        private String code;
        private String name;

        private LimitConditionType(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum FunctionType {
        SUM("sum", "numeric", "\u6c42\u548c"),
        MAX("max", "numeric", "\u6c42\u6700\u5927\u503c"),
        MIN("min", "numeric", "\u6c42\u6700\u5c0f\u503c"),
        AVG("avg", "numeric", "\u6c42\u5e73\u5747\u503c"),
        COUNT("count", "numeric", "\u8ba1\u6570"),
        EXIST("exist", "boolean", "\u6c42\u662f\u5426\u5b58\u5728"),
        COUNT_DIS("countd", "numeric", "\u53bb\u91cd\u8ba1\u6570");

        private String code;
        private String outputType;
        private String name;

        private FunctionType(String code, String outputType, String name) {
            this.code = code;
            this.outputType = outputType;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getOutputType() {
            return this.outputType;
        }

        public void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum OperateType {
        EQ("eq", "\u7b49\u4e8e"),
        GT("gt", "\u5927\u4e8e"),
        LT("lt", "\u5c0f\u4e8e"),
        GTE("gte", "\u5927\u4e8e\u7b49\u4e8e"),
        LTE("lte", "\u5c0f\u4e8e\u7b49\u4e8e"),
        BETWEEN("between", "\u4e4b\u95f4");

        private String code;
        private String name;

        private OperateType(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum RightCondType {
        ENUM_TYPE("enum", "\u679a\u4e3e\u503c"),
        CUSTOM_VALUE("customValue", "\u81ea\u5b9a\u4e49\u503c"),
        MECHANISM_VARIABLE("mechanismVariable", "\u673a\u5236\u53c2\u6570"),
        CUSTOM_FUNCTION("customFunction", "\u81ea\u5b9a\u4e49\u51fd\u6570"),
        TASK("task", "\u4efb\u52a1\u5b57\u6bb5");

        private String code;
        private String name;

        private RightCondType(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum FieldValueType {
        STRING("string", "\u5b57\u7b26\u4e32"),
        NUMERIC("numeric", "\u6570\u503c\u7c7b\u578b"),
        BOOLEAN("boolean", "\u5e03\u5c14\u7c7b\u578b"),
        DATETIME("datetime", "\u65e5\u671f\u65f6\u95f4\u7c7b\u578b"),
        DATE("date", "\u65e5\u671f\u7c7b\u578b");

        private String code;
        private String name;

        private FieldValueType(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum ConditionType {
        HALF_CUSTOM("half_custom", "\u534a\u5b9a\u5236"),
        STANDARD("standard", "\u6807\u51c6\u5316"),
        PRIMARY("primary", "\u57fa\u672c\u6761\u4ef6"),
        HIGH_GRADE("highGrade", "\u9ad8\u7ea7\u6761\u4ef6"),
        CONDITION("condition", "\u6761\u4ef6"),
        API("api", "API"),
        LIMIT_CONDITION("limitCondition", "\u9650\u5236");

        private String code;
        private String name;

        private ConditionType(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum ComponentType {
        SELECTOR("selector", "\u4e0b\u62c9\u9009\u62e9"),
        OPEN_WINDOW("openWindow", "\u5f00\u7a97"),
        NUMERIC("numeric", "\u6570\u503c"),
        OPTION("option", "\u4e0b\u62c9\u9009\u62e9"),
        CHECK_VALID("checkValid", "\u6821\u9a8c\u63d0\u793a"),
        ASSIGNMENT("assignment", "\u8d4b\u503c");

        private String code;
        private String name;

        private ComponentType(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

