package com.digiwin.athena.set.part;

import lombok.Data;

import java.util.List;

/**
 * @title: ThresholdCondition
 * @author: linc
 * @date 2023/10/14 16:33
 * @version: 1.0
 */
@Data
public class ThresholdCondition {
    private String type;

    private List<ConditionItem> items;

    public String toJavaScriptExpression() {
        StringBuilder expressionBuilder = new StringBuilder();
        expressionBuilder.append("(");

        for (int i = 0; i < items.size(); i++) {
            ConditionItem item = items.get(i);

            if (item.getType().equals("OR_GROUP") || item.getType().equals("AND_GROUP")) {
                String itemExpression = item.toJavaScriptExpression();
                expressionBuilder.append(itemExpression);
            } else {
                String leftField = item.getLeftField();
                String rightField = item.getRightField();
                String op = item.getOp();

                String itemExpression = operator(op,leftField,rightField);// String.format("(%s %s %s)", leftField, op, rightField);
                expressionBuilder.append(itemExpression);
            }

            if (i < items.size() - 1) {
                if (type.equals("OR_GROUP")) {
                    expressionBuilder.append(" || ");
                } else if (type.equals("AND_GROUP")) {
                    expressionBuilder.append(" && ");
                }
            }
        }

        expressionBuilder.append(")");

        return expressionBuilder.toString();
    }

    public String operator(String op,String leftField,String rightField) {
        String operator;
        switch (op) {
            case "Equals":
                operator = "==";
                break;
            case "NotEqual":
                operator = "!=";
                break;
            case "Greater":
                operator = ">";
                break;
            case "Less":
                operator = "<";
                break;
            case "GreaterThanEqual":
                operator = ">=";
                break;
            case "LessThanEqual":
                operator = "<=";
                break;
            case "Include":
                return String.format("(%s.indexOf(%s) !== -1)", "data." + leftField + ".toString()", "data." + rightField + ".toString()");
            case "NotInclude":
                return String.format("(%s.indexOf(%s) === -1)", "data." + leftField + ".toString()", "data." + rightField + ".toString()");
            default:
                throw new IllegalArgumentException("Unsupported operator: " + op);
        }

        return String.format("(%s %s %s)", "data." + leftField, operator, "data." + rightField);
    }
}
