package com.digiwin.athena.domain.erp;

import org.springframework.data.annotation.Id;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-06-13 14:29
 **/

public class ErpField {

    public static final String type_String="String";
    public static final String type_Number="Number";
    public static final String type_Object="Object";
    public static final String type_Arrary="Arrary";


    @Id
    private String mongoId;

    private String id;
    private Map<String,String> name;
    //String|Number|Object|Arrary
    private String type;

    private Boolean visible=true;
    //是否作为签核变量，默认导入时把数字类中作为变量
    private Boolean asApproveVariable;

    private Boolean is_business_key;

    private List<NameValue> picks;

    private String enum_key;

    public String getEnum_key() {
        return enum_key;
    }

    public void setEnum_key(String enum_key) {
        this.enum_key = enum_key;
    }

    public String getMongoId() {
        return mongoId;
    }

    public void setMongoId(String mongoId) {
        this.mongoId = mongoId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, String> getName() {
        return name;
    }

    public void setName(Map<String, String> name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getVisible() {
        return visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public Boolean getAsApproveVariable() {
        if(null==asApproveVariable && type_Number.equalsIgnoreCase(type)){
            return true;
        }

        return asApproveVariable;
    }

    public Boolean getIs_business_key() {
        return is_business_key;
    }

    public void setIs_business_key(Boolean is_business_key) {
        this.is_business_key = is_business_key;
    }

    public List<NameValue> getPicks() {
        return picks;
    }

    public void setPicks(List<NameValue> picks) {
        this.picks = picks;
    }

    public void setAsApproveVariable(Boolean asApproveVariable) {
        this.asApproveVariable = asApproveVariable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErpField erpField = (ErpField) o;
        return id.equals(erpField.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

}
