/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.domain.core.flow;

import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.flow.FlowLink;
import com.digiwin.athena.domain.core.flow.FlowNode;
import java.util.ArrayList;
import java.util.List;

public class FlowGraph
extends TenantObject {
    private List<FlowNode> nodes;
    private List<FlowLink> links;
    private String startNodeId;
    private String endNodeId;
    private String nooutEndNodeId;

    public static FlowGraph simple(String code, String activityCode) {
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setCode(code);
        flowGraph.setTenantId("SYSTEM");
        flowGraph.setVersion("1.0");
        flowGraph.setLinks(new ArrayList<FlowLink>());
        flowGraph.setNodes(new ArrayList<FlowNode>());
        FlowNode start = new FlowNode();
        start.setId("start");
        start.setType("start");
        flowGraph.getNodes().add(start);
        FlowNode endNode = new FlowNode();
        endNode.setId("end");
        endNode.setType("end");
        flowGraph.getNodes().add(endNode);
        FlowNode activity = new FlowNode();
        activity.setId("activity01");
        activity.setType("activity");
        activity.setActivityCode(activityCode);
        flowGraph.getNodes().add(activity);
        FlowLink link1 = new FlowLink();
        link1.setFrom("start");
        link1.setTo("activity01");
        flowGraph.getLinks().add(link1);
        FlowLink link2 = new FlowLink();
        link2.setFrom("activity01");
        link2.setTo("end");
        flowGraph.getLinks().add(link2);
        return flowGraph;
    }

    public static FlowGraph basic(String code) {
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setCode(code);
        flowGraph.setTenantId("SYSTEM");
        flowGraph.setVersion("1.0");
        flowGraph.setLinks(new ArrayList<FlowLink>());
        flowGraph.setNodes(new ArrayList<FlowNode>());
        FlowNode start = new FlowNode();
        start.setId("start");
        start.setType("start");
        flowGraph.getNodes().add(start);
        FlowNode endNode = new FlowNode();
        endNode.setId("end1");
        endNode.setDataKey("end1");
        endNode.setType("end");
        flowGraph.getNodes().add(endNode);
        return flowGraph;
    }

    public String findStartNodeId() {
        if (null != this.getStartNodeId()) {
            return this.getStartNodeId();
        }
        for (FlowNode node : this.getNodes()) {
            if (!"start".equalsIgnoreCase(node.getType())) continue;
            this.setStartNodeId(node.getId());
            return node.getId();
        }
        return null;
    }

    public String findEndNodeId() {
        if (null != this.getEndNodeId()) {
            return this.getEndNodeId();
        }
        for (FlowNode node : this.getNodes()) {
            if (!"end".equalsIgnoreCase(node.getType())) continue;
            this.setEndNodeId(node.getId());
            return node.getId();
        }
        return null;
    }

    public List<FlowNode> getNodes() {
        return this.nodes;
    }

    public List<FlowLink> getLinks() {
        return this.links;
    }

    public String getStartNodeId() {
        return this.startNodeId;
    }

    public String getEndNodeId() {
        return this.endNodeId;
    }

    public String getNooutEndNodeId() {
        return this.nooutEndNodeId;
    }

    public void setNodes(List<FlowNode> nodes) {
        this.nodes = nodes;
    }

    public void setLinks(List<FlowLink> links) {
        this.links = links;
    }

    public void setStartNodeId(String startNodeId) {
        this.startNodeId = startNodeId;
    }

    public void setEndNodeId(String endNodeId) {
        this.endNodeId = endNodeId;
    }

    public void setNooutEndNodeId(String nooutEndNodeId) {
        this.nooutEndNodeId = nooutEndNodeId;
    }
}

