/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.set.part;

import java.util.List;
import org.springframework.util.CollectionUtils;

public class ConditionItem {
    private String type;
    private List<ConditionItem> items;
    private String leftField;
    private String op;
    private String rightField;

    public String toJavaScriptExpression() {
        if (!CollectionUtils.isEmpty(this.items)) {
            StringBuilder groupExpression = new StringBuilder();
            groupExpression.append("(");
            for (int i = 0; i < this.items.size(); ++i) {
                ConditionItem item = this.items.get(i);
                String itemExpression = item.toJavaScriptExpression();
                groupExpression.append(itemExpression);
                if (i >= this.items.size() - 1) continue;
                groupExpression.append(" && ");
            }
            groupExpression.append(")");
            return groupExpression.toString();
        }
        return this.operator();
    }

    public String operator() {
        String operator;
        switch (this.op) {
            case "Equals": {
                operator = "==";
                break;
            }
            case "NotEqual": {
                operator = "!=";
                break;
            }
            case "Greater": {
                operator = ">";
                break;
            }
            case "Less": {
                operator = "<";
                break;
            }
            case "GreaterThanEqual": {
                operator = ">=";
                break;
            }
            case "LessThanEqual": {
                operator = "<=";
                break;
            }
            case "Include": {
                return String.format("%s.indexOf(%s) !== -1", "data." + this.leftField + ".toString()", "data." + this.rightField + ".toString()");
            }
            case "NotInclude": {
                return String.format("%s.indexOf(%s) === -1", "data." + this.leftField + ".toString()", "data." + this.rightField + ".toString()");
            }
            default: {
                throw new IllegalArgumentException("Unsupported operator: " + this.op);
            }
        }
        return String.format("(%s %s %s)", "data." + this.leftField, operator, "data." + this.rightField);
    }

    public String getType() {
        return this.type;
    }

    public List<ConditionItem> getItems() {
        return this.items;
    }

    public String getLeftField() {
        return this.leftField;
    }

    public String getOp() {
        return this.op;
    }

    public String getRightField() {
        return this.rightField;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setItems(List<ConditionItem> items) {
        this.items = items;
    }

    public void setLeftField(String leftField) {
        this.leftField = leftField;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public void setRightField(String rightField) {
        this.rightField = rightField;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionItem)) {
            return false;
        }
        ConditionItem other = (ConditionItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<ConditionItem> this$items = this.getItems();
        List<ConditionItem> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        String this$leftField = this.getLeftField();
        String other$leftField = other.getLeftField();
        if (this$leftField == null ? other$leftField != null : !this$leftField.equals(other$leftField)) {
            return false;
        }
        String this$op = this.getOp();
        String other$op = other.getOp();
        if (this$op == null ? other$op != null : !this$op.equals(other$op)) {
            return false;
        }
        String this$rightField = this.getRightField();
        String other$rightField = other.getRightField();
        return !(this$rightField == null ? other$rightField != null : !this$rightField.equals(other$rightField));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConditionItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<ConditionItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        String $leftField = this.getLeftField();
        result = result * 59 + ($leftField == null ? 43 : $leftField.hashCode());
        String $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : $op.hashCode());
        String $rightField = this.getRightField();
        result = result * 59 + ($rightField == null ? 43 : $rightField.hashCode());
        return result;
    }

    public String toString() {
        return "ConditionItem(type=" + this.getType() + ", items=" + this.getItems() + ", leftField=" + this.getLeftField() + ", op=" + this.getOp() + ", rightField=" + this.getRightField() + ")";
    }
}

