package com.digiwin.athena.kg.activity;


import com.digiwin.athena.config.ScheduleRule;
import com.digiwin.athena.domain.common.EntityRef;
import com.digiwin.athena.domain.common.MatchCondition;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.ConditionalAssignment;
import com.digiwin.athena.domain.core.LifecycleEvent;
import com.digiwin.athena.domain.core.StateMap;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.definition.EocUnit;
import com.digiwin.athena.domain.definition.*;
import com.digiwin.athena.domain.definition.actions.DataEntity;
import com.digiwin.athena.domain.definition.actions.MapAction;
import com.digiwin.athena.domain.definition.features.DataTagging;
import com.digiwin.athena.domain.definition.times.TimeDefinition;
import com.digiwin.athena.dto.TenantSummaryFieldsDto;
import lombok.Data;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Properties;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.Transient;
import org.springframework.data.neo4j.core.schema.CompositeProperty;
import org.springframework.data.neo4j.core.schema.Node;

import java.util.List;
import java.util.Map;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-10-29 18:20
 **/
//@NodeEntity
@Data
//@Node("Activity")
public class Activity extends TenantObject implements Comparable<Activity> {



    private List<String> inclusionTenant;

    //租户级卡片标题定义
    @Transient
    private TenantCardTitleDefinition tenantCardTitleDefinition;

    @Transient
    private String appName;

    private String resCode;

    @org.springframework.data.annotation.Transient
    private String productName;

    @org.springframework.data.annotation.Transient
    private String feeInfo;

    private String title;

    private String subTitle;

    private String subDescription;

    private String nameSpace;

    private Boolean multipleSelect;
    @Transient
    //json 获取数据action
    private Map<String, Object> getDataAction;
    //json 相关查询action  可能包含getDataAction
    @Transient
    private List<Map<String, Object>> relationQueries;
    //json 提交数据action
    @Transient
    private List<Map<String, Object>> submitActions;
    //json
    @org.springframework.data.annotation.Transient
    private Boolean usedTenantSummaryFields;
    @org.springframework.data.annotation.Transient
    private TenantSummaryFieldsDto tenantSummaryFields;
    @Transient
    private List<Map<String, Object>> summaryFields;
    @Transient
    private Map<String, Object> summary;
    @Transient
    private Map<String, Object> businessInfo;
    @Transient
    private Map<String, Object> searchKey;
    @Transient
    private Map<String, Object> projectInfo;
    // 开发平台选中的摘要字段
    @Transient
    private List<Map<String, Object>> canSelectedSummaryFields;
    //json 保存过滤按钮
    @Transient
    private List<Map<String, Object>> filters;
    //json 操作相关
    @Transient
    private List<Map<String, Object>> operations;
    @Transient
    private List<Map<String, Object>> groupFields;
    @Transient
    private Map<String, Object> getTaskData;
    @Transient
    private List<Map<String, Object>> checkItems;
    @Transient
    private Map<String, Object> reason;
    @Transient
    private Map<String, Object> getFormulaAction;
    @Transient
    private Map<String, Object> countItems;
//    @Transient
//    private Map<String, Map> language;
    //0901新版本json定义
    //数据源
    @Transient
    private Map<String, Object> dataSources;
    //数据查询器
    @Transient
    private List<Map<String, Object>> dataFilters;
    //数据加工器
    @Transient
    private List<Map<String, Object>> dataProcessors;
    //页面
    @Transient
    private Map<String, Object> pages;

    //指定结束日期
    private KgExpectedDuration expectedDuration;

    @org.springframework.data.annotation.Transient
    private Map<String, Object> dueDateRule;


    private Integer emergency;
    private Integer sequence;
    //执行类型 参见ActivityExecuteTypeEnum: MANUAL AUTO
    private String executeType;
    //活动类型  CHECK检查 SOLVE异常排除 ADJUSTMENT REPORT  PROCESS MESSAGE
    private String category;
    // 参见ActivityPatternEnum:  NONE,BUSINESS,ADJUSTMENT,MECHANISM;
    private String pattern;

    //里程碑 为true 表示业务型 有细项指标
    private Boolean milestone;

    private Boolean showFlow;

    //审核相关
    //审核任务关联的申请关卡
    private List<String> startApproveActivity;
    private String startApproveActivityName;
    private String targetApproveActivity;
    // 0:核决，1：群组
    @Deprecated
    private Integer approveType;
    //0串接 1并接，目前场景只有串接
    @Deprecated
    private Integer groupDispatchType;
    //群组 审核关卡 保存在mongo
    @Transient
    @Deprecated
    private List<ActivityApprove> approves;
    //核决
    @Deprecated
    private String decisionRule;

    private String approveLevel;
    private ApproveInfo approve;
    private Boolean allowSubLevel;
    private Boolean needEnableApprove;
    private List<DynamicApproveInfo> dynamicApproves;

    //消息定义部分 发送消息单独作为一个节点
    @Transient
    private List<Message> messages;
    @Transient
    private Boolean saveById = true;
    //附件
    private Object attachment;
    //页面全局配置
    private Map<String, Object> activityParameter;

    @Relationship(type="Creates")
    private List<DataEntity> creates;

    //dto
    private String activityId;
    //这个字段比较特殊,因为历史原因在getActivitiesWithMultiLanguage需要返回map,在getActivityDefinition需要返回string
    private Object activityName;


    //是否支持任务卡合并
    private Boolean merge;

    private List<KgOverdueRule> overdueRules;

    private Boolean assignAble;
    //定义任务可转派范围
    private UserDefinition assignTo;
    private AssignConfig assignConfig;
    //定义任务执行者
    private UserDefinition personOnDuty;
    //定义任务辅助执行者
    private UserDefinition assistant;
    //其他关联人
    private UserDefinition relatedUsers;

    @Transient
    private Map<String, Object> extendFields;

    //权限控制相关，格式为 应用code:模组code
    private String authorityPrefix;

    private String approvePlanDesc;

    private Boolean dependOnGroundEnd;

    private EocUnit process_EOC;

    private Map<String, Object> config;
    //作业分组code 关联mongodb的 applicationGroup
    private String groupCode;

    private Object presetVariables;

    private Integer status;

    private ReminderRule reminderRule;

    private Boolean subReport;

    /**
     * abi报表 禁用打印标识 false：否 true：是
     */
    private Boolean disablePrintFlag;

    /**
     * abi报表 禁用导出标识 false：否 true：是
     */
    private Boolean disableExportFlag;

    // 对应设计器流程设定的表单信息
    private Map<String,Object> bindForm;
    //字段权限，从task表中获取
    private List<Object> fieldConfig;
    // 后台任务,不对外展示
    private Boolean daemon;
    /**
     * ABI报表类型（prpttpl-打印凭证；ebibase-明细）
     */
    private String categoryAbi;

    /**
     * 是否客制页面
     */
    private Boolean isCustomize;

    /**
     * 客制页面是否接入了加密
     */
    private Boolean customizePageEncrypted;

    /**
     * 客制页面是否接入了水印
     */
    private Boolean customizePageWatermark;
    /**
     * 条件分派
     */
    private List<ConditionalAssignment> conditionalAssignment;
    /**
     * 应用类型，数据驱动（1.0）：1，模型驱动（2.0）：5
     */
    private Integer appType;

    @Deprecated
    @org.springframework.data.annotation.Transient
    private String projectCode;
    /** @deprecated */
    @Deprecated
    @org.springframework.data.annotation.Transient
    private String parentCode;
    /** @deprecated */
    @Deprecated
    @org.springframework.data.annotation.Transient
    private String group;
    @org.springframework.data.annotation.Transient
    private Map<String, Object> features;
    @org.springframework.data.annotation.Transient
    private List<String> from;
    @org.springframework.data.annotation.Transient
    private List<String> to;
    @org.springframework.data.annotation.Transient
    private String defaultState;
    @org.springframework.data.annotation.Transient
    private List<StateMap> stateMaps;
    @org.springframework.data.annotation.Transient
    private TimeDefinition dueDate;
    @org.springframework.data.annotation.Transient
    private UserDefinition onDuty;
    @org.springframework.data.annotation.Transient
    private String type;
    @org.springframework.data.annotation.Transient
    private String flowCode;
    @org.springframework.data.annotation.Transient
    private FlowGraph flow;
    @org.springframework.data.annotation.Transient
    private List<ExceptionResolvePlan> resolvePlans;
    @org.springframework.data.annotation.Transient
    private String pageCode;
    @org.springframework.data.annotation.Transient
    private String assistantType;
    @org.springframework.data.annotation.Transient
    private String assistantExecuteTime;
    @org.springframework.data.annotation.Transient
    private String masterCode;
    @org.springframework.data.annotation.Transient
    private TaskDimension dimension;
    @org.springframework.data.annotation.Transient
    private Object inputData;
    @org.springframework.data.annotation.Transient
    private String versionNumber;
    @org.springframework.data.annotation.Transient
    private String nameAlias;
    @org.springframework.data.annotation.Transient
    private Map<String, Object> listener;
    @org.springframework.data.annotation.Transient
    private UserDefinition executor;
    @org.springframework.data.annotation.Transient
    private ScheduleRule scheduleRule;
    @org.springframework.data.annotation.Transient
    private String flowEntityId;
    @org.springframework.data.annotation.Transient
    private List<AtmcData> atmcDatas;
    @org.springframework.data.annotation.Transient
    private List<FieldDescription> inputVariables;
    @org.springframework.data.annotation.Transient
    private List<FieldDescription> outputVariables;
    @org.springframework.data.annotation.Transient
    private List<LifecycleEvent> events;
    @org.springframework.data.annotation.Transient
    private List<AssistantTask> assistantTasks;
    @org.springframework.data.annotation.Transient
    private Map<String, Object> meta;
    @org.springframework.data.annotation.Transient
    private List<DataTagging> dataFeatures;
    @org.springframework.data.annotation.Transient
    private MapAction mapAction;

    @Deprecated
    @org.springframework.data.annotation.Transient
    private String entityId;
    @Deprecated
    @org.springframework.data.annotation.Transient
    private Map<String, List<String>> tags;
    @Deprecated
    @org.springframework.data.annotation.Transient
    private List<EntityRef> dependencies;
    @Deprecated
    @org.springframework.data.annotation.Transient
    private List<EntityRef> provides;
    @Deprecated
    @org.springframework.data.annotation.Transient
    private List<MatchCondition> matches;
    @org.springframework.data.annotation.Transient
    private String evlModelCode;

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof Activity)) {
            return false;
        } else {
            Activity other = (Activity)o;
            if(this.getCode().equals(other.getCode()) && this.getVersion().equals(other.getVersion())){
                return true;
            }else {
                return false;
            }
        }
    }

    @Override
    public int hashCode() {
        int result = 17; // Arbitrary non-zero constant
        result = 31 * result + (getCode() != null ? getCode().hashCode() : 0);
        result = 31 * result + (getVersion() != null ? getVersion().hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Activity o) {
        return this.getSequence() - o.getSequence();
    }
}
