/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.set.part;

import com.digiwin.athena.set.part.ConditionItem;
import java.util.List;

public class ThresholdCondition {
    private String type;
    private List<ConditionItem> items;

    public String toJavaScriptExpression() {
        StringBuilder expressionBuilder = new StringBuilder();
        expressionBuilder.append("(");
        for (int i = 0; i < this.items.size(); ++i) {
            ConditionItem item = this.items.get(i);
            if (item.getType().equals("OR_GROUP") || item.getType().equals("AND_GROUP")) {
                String itemExpression = item.toJavaScriptExpression();
                expressionBuilder.append(itemExpression);
            } else {
                String leftField = item.getLeftField();
                String rightField = item.getRightField();
                String op = item.getOp();
                String itemExpression = this.operator(op, leftField, rightField);
                expressionBuilder.append(itemExpression);
            }
            if (i >= this.items.size() - 1) continue;
            if (this.type.equals("OR_GROUP")) {
                expressionBuilder.append(" || ");
                continue;
            }
            if (!this.type.equals("AND_GROUP")) continue;
            expressionBuilder.append(" && ");
        }
        expressionBuilder.append(")");
        return expressionBuilder.toString();
    }

    public String operator(String op, String leftField, String rightField) {
        String operator;
        switch (op) {
            case "Equals": {
                operator = "==";
                break;
            }
            case "NotEqual": {
                operator = "!=";
                break;
            }
            case "Greater": {
                operator = ">";
                break;
            }
            case "Less": {
                operator = "<";
                break;
            }
            case "GreaterThanEqual": {
                operator = ">=";
                break;
            }
            case "LessThanEqual": {
                operator = "<=";
                break;
            }
            case "Include": {
                return String.format("(%s.indexOf(%s) !== -1)", "data." + leftField + ".toString()", "data." + rightField + ".toString()");
            }
            case "NotInclude": {
                return String.format("(%s.indexOf(%s) === -1)", "data." + leftField + ".toString()", "data." + rightField + ".toString()");
            }
            default: {
                throw new IllegalArgumentException("Unsupported operator: " + op);
            }
        }
        return String.format("(%s %s %s)", "data." + leftField, operator, "data." + rightField);
    }

    public String getType() {
        return this.type;
    }

    public List<ConditionItem> getItems() {
        return this.items;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setItems(List<ConditionItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThresholdCondition)) {
            return false;
        }
        ThresholdCondition other = (ThresholdCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<ConditionItem> this$items = this.getItems();
        List<ConditionItem> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThresholdCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<ConditionItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "ThresholdCondition(type=" + this.getType() + ", items=" + this.getItems() + ")";
    }
}

