package com.digiwin.athena.domain.core;

import com.digiwin.athena.config.ScheduleRule;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.definition.*;
import com.digiwin.athena.domain.definition.features.DataTagging;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Getter
@Setter
public class Execution extends TenantObject {

    /**
     * 执行者
     */
    private UserDefinition executor;

    private DefinitionMeta executorMeta;

    /**
     * 执行逻辑具体配置
     */
    private Map<String,Object> config = new HashMap<>();

    /**
     * 对应flow流程.当task和plan时有效
     */
    private String flowEntityId;

    /**
     * 任务推送到atmc数据
      */
    private List<AtmcData> atmcDatas;

    /**
     * 辅助执行任务
     */
    private List<AssistantTask> assistantTasks;

    /**
     * 业务执行人
     */
    private List<Identity> presetVariables;

    /**
     * 元数据
     */
    private Map<String,Object> meta;

    /**
     * 数据特征
     */
    private List<DataTagging> dataFeatures;

    /**
     * 催办规则
     */
    private ReminderRule reminderRule;

    /**
     * 生命周期事件
     */
    private List<LifecycleEvent> events ;

    /**
     * 调度规则
     */
    private ScheduleRule scheduleRule;
}
