package com.digiwin.athena.dto;

import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class ActivityBaseInfoVO {
    /**
     * 任务ID
     */
    private String taskId="";
    /**
     * 是否开启二级审核
     */
    private Boolean allowSubLevel = false;
    /**
     * 是否需签核
     */
    private Boolean needEnableApprove = true;
    /**
     * 签核排序
     */
    private Integer sequence;
    /**
     * 二级审核列表
     */
    private List<Map<Object,Object>> subApprove;
    /**
     * 任务名称
     */
    private String taskName="";
    /**
     * 活动ID
     */
    private String activityId;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 提交签核任务的任务名称
     */
    private String startApproveActivityName;
    private String approvePlanDesc;
    /**
     * 租户版本
     */
    private String activityVersion;
    /**
     * 任务配置（是否支持分页，是否支持拆分等等）
     */
    private Map<String, Object> config;
    /**
     * 是否支持手动提交
     */
    private Boolean manualAble;
    /**
     * 项目执行类型为mainline时，对应的主线任务ID
     */
    private String mainLineTaskId;
    /**
     * 权限前缀
     */
    private String authorityPrefix;
}
