package com.digiwin.athena.kg.struct;

import com.digiwin.athena.kg.domain.DomainEntity;

import lombok.Data;
import org.neo4j.ogm.annotation.NodeEntity;

import java.util.List;

/**
 *
 * 字段的描述,可用于表单/表格/详情展示等.
 * 一个字段的值有获取或者校验的规则,
 * 可用于描述json格式. 注意:当用于json描述时第一层field是包装层,没有业务意义
 **/
@Data
@NodeEntity
public class Field extends DomainEntity implements Comparable<Field>{

    private String name;
    //字段显示名称
    private String label;
    //字段key
    private String key;
    //字段值,name用于展示字段的显示值,如key=role value=roleId001 name=采购员,如果name为null展示value的值
    private Object value;
    //字段类型  string integer long double date array object等
    private String  type;
    //字段展示类型,支持string text number number_range date time datetime date_range time_range datetime_range radio checkbox select multiSelect
    private String displayType;
    //当type为array时表示内部类型,值域同type
    private String componentType;
    //业务数据类型,如当前值是一个角色id
    private String businessType;
    //字段描述
    private String description;
    //排序值
    private Integer sort=100;

    private Boolean required;

    private Boolean readOnly;

    private Boolean hidden;

    //获取数据规则
    private DataRetrieveRule retrieveRule;
    //数据校验规则
    private List<DataCheckRule> checkRules;
    //Todo tag是字符串类型 还是key:value类型呢?哪种比较好? tag在这里定义是否合适呢?
    private List<String> tags;
    //当type=checkbox radio select时的选项
    private List<Option> options;
    private Option optionMapper;
    private List<Option> valueMappers;
    //当type=obj或者array时会有子域
    private List<Field> fields;

    private String format;

    @Override
    public int compareTo(Field o) {
        return this.getSort()-o.getSort();
    }
}
