package com.digiwin.athena.mechanism.widgets;



import com.digiwin.athena.mechanism.widgets.activity.*;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 活动的类型 esp http jsonValueSet invoketask invokeProject
 **/
@Data
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME,include = JsonTypeInfo.As.PROPERTY,property = "type",visible=true)
@JsonSubTypes({
        @JsonSubTypes.Type(value = FilterActivityWidget.class,name="variableFilter"),
        @JsonSubTypes.Type(value = VariableSetActivityWidget.class,name="variableSet"),
        @JsonSubTypes.Type(value = CalculateActivityWidget.class,name="variableCalculate"),
        @JsonSubTypes.Type(value = HttpActivityWidget.class,name="http"),
        @JsonSubTypes.Type(value = EspActivityWidget.class,name="esp"),
        @JsonSubTypes.Type(value = EmailActivityWidget.class,name="email"),
        @JsonSubTypes.Type(value = IMActivityWidget.class,name="im"),
        @JsonSubTypes.Type(value = TaskInitiateActivityWidget.class,name="taskInitiate"),
        @JsonSubTypes.Type(value = DefaultActivityWidget.class,name="script"),
        @JsonSubTypes.Type(value = GatewayWidget.class,name="gateway")

})
public class ActivityWidget extends Widget {


    private Map<String,Object> config= new HashMap<>();


}
