package com.digiwin.athena.domain.core.process;

import lombok.Data;

/**
 * 流程变量 - 页面新增 属于流程的每一个节点
 *
 * @author 於海兵
 */
@Data
public class CustomVariable {

    /**
     * 数据类型
     */
    private String dataType = ProcessCustomVariableEnum.STRING.getCode();

    /**
     * 变量名称
     */
    private String varName;

    /**
     * 参数编码(机制参数使用)
     */
    private String paramCode;

    /**
     * actionID(机制参数使用)
     */
    private String actionId;

    /**
     * 参数名称(机制参数使用)
     */
    private String paramName;

    /**
     * 是否为数组
     */
    private Boolean isArray = false;

    /**
     * 是否必填
     */
    private Boolean required = false;

    /**
     * 模型值
     */
    private Object defaultValue;

    /**
     * 描述
     */
    private String description;

    /**
     * 数据目标，当是业务对象的时候，需要传过来
     */
    private String serviceCode;

    /**
     * 数据目标，当是业务对象的时候，需要传过来
     */
    private String modeCode;

    /**
     * DTD参数---映射
     */
    private String mappingCode;

    /**
     * 数据code
     */
    private String code;

}
