package com.digiwin.athena.domain.core;

import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.process.InteractiveAbleConfig;
import com.digiwin.athena.domain.core.process.PlanEndTimeDefinition;
import com.digiwin.athena.domain.core.process.ProcessDecisionConfig;
import com.digiwin.athena.domain.customBizTask.CustGroupSkipCondition;
import com.digiwin.athena.domain.definition.*;
import com.digiwin.athena.domain.definition.times.ExpectedDuration;
import com.digiwin.athena.domain.definition.times.TimeDefinition;
import com.digiwin.athena.dto.TenantCardTitleDefinition;
import com.digiwin.athena.dto.TenantSummaryFieldsDto;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Transient;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
数据状态和状态之间的转换关系,如请购单-(请转采)->采购单


 config配置支持
 是否支持分批supportPart;
 是否支持拆分supportSpilt;
 "distribute": {
 "dataVariable": "ooo"
 }

 config:{
    supportPart:false,
    supportSpilt:false,
    skipAble:true,//是否可以跳过
    rollbackConfig:{
        enable:false,//是否需要回滚
        rollbackAble:false,//是否能够做到回滚
        flowId:''
    }
 }

 "listener"：{
 "afterLeave（任务完成后）": [ {
 "sequence": 1, //1,2,3
 "handler":"mergeTask", // 处理器类型为：合并任务
 "targetTaskCode":"", // 目标任务的code，用于筛选被合并的任务实例（与relationData联合筛选）
 "deleteDataKey": "" // 删除数据的key
 },
 {
 "sequence": 执行顺序, //1,2,3
 "handler":"mergeTask", // 处理器类型为：合并任务
 "targetTaskCode":"", // 目标任务的code，用于筛选被合并的任务实例（与relationData联合筛选）
 "addDataKey": "", // 新增数据的key
 "relationDataKey":{} // 关联数据的key，用于新增数据时查找被合并的任务实例
 }
 ]
 }
 **/
@Getter
@Setter
public class Task extends Execution {


    /**
     * dataGroup表的code
     */
    private String group;

    /**
     * 响应码
     */
    private String resCode;

    /**
     * 计费信息：数据中台收集数据用
     */
    private Map<String, Object> feeInfo;

    /**
     * 特征信息
     */
    private Map<String, Object> features;

    /**
     * 任务开始数据状态
     */
    private List<String> from = new ArrayList<>();

    /**
     * 任务结束数据状态
     */
    private List<String> to = new ArrayList<>();

    /**
     * 默认数据状态
     */
    private String defaultState;

    /**
     * 状态集合
     */
    private List<StateMap> stateMaps = new ArrayList<>();
    /**
     * 时间由对应流程体现
     */
    private TimeDefinition dueDate;
    /**
     * 是否里程碑
     */
    private Boolean milestone;
    /**
     * 任务的看护者，任务除了有执行人外，可能还需要有个类似于监管者的角色
     */
    private UserDefinition onDuty;

    /**
     * 执行类型 参见ActivityExecuteTypeEnum: MANUAL AUTO
     */
    private String executeType;
    /**
     * 业务类型，参见ActivityPatternEnum:  NONE,BUSINESS,ADJUSTMENT,MECHANISM;
     */
    private String pattern;
    /**
     * 活动类型  CHECK检查 SOLVE异常排除 ADJUSTMENT REPORT  PROCESS MESSAGE
     * PROCESS CHECK SOLVE  REPLY TRACE MODIFY REPORT StockChange SUGGESTION APPROVAL,MECHANISM,PARADIGM
     */
    private String category;
    /**
     * 33514,增加字段,兼容驱动2.0业务类型
     */
    private String drivenCategory;

    /**
     * 任务类型 business业务型任务(默认) check检查型 approve签核型 solve异常排除 composite组合型 signal信号型
     */
    private String type;

    /**
     * 是否开启二级签核
     */
    private Boolean allowSubLevel=false;
    /**
     * 是否签核
     */
    private Boolean needEnableApprove=true;
    /**
     * 签核等级
     */
    private String approveLevel;
    /**
     * 签核任务
     */
    private Object dynamicApproves;

    /**
     * type=flow时   流程的id
     */
    private String flowCode;
    /**
     * 用于返回给接口 流程
     */
    private FlowGraph flow;

    /**
     * type=resolver  异常排除计划
     */
    private List<ExceptionResolvePlan> resolvePlans;

    /**
     * 页面设计code
     */
    private String pageCode;
    /**
     * 预期完成时间
     */
    @Deprecated
    private ExpectedDuration expectedDuration;

    /**
     * 紧急程度
     */
    @Deprecated
    private Integer emergency;
    /**
     * 任务序号
     */
    private Integer sequence;
    /**
     *  签核卡下面显示签核信息
     */
    @Deprecated
    private Boolean showFlow;
    /**
     * 是否支持任务卡合并
     */
    private Boolean merge;

    /**
     * 逾期规则
     */
    private List<OverdueRule> overdueRules;

    /**
     * 是否可转派
     */
    private Boolean assignAble;
    /**
     * 定义任务可转派范围
     */
    private UserDefinition assignTo;
    /**
     * 定义任务辅助执行者
     */
    private UserDefinition assistant;
    /**
     * 转派配置
     */
    private AssignConfig assignConfig;

    /**
     * 其他关联人
     */
    private UserDefinition relatedUsers;

    /**
     * 助手类型
     */
    private String assistantType;
    /**
     * 助手执行时间
     */
    private String assistantExecuteTime;
    /**
     * 驱动任务时，主任务code
     */
    private String masterCode;
    /**
     * 任务维度
     */
    private TaskDimension dimension;


    /**
     * 兼容性字段-签核配置
     */
    private Object approve;
    /**
     * 兼容性字段-定义任务辅助执行者
     */
    private UserDefinition personOnDuty;
    /**
     * 任务id
     */
    private String activityId;
    /**
     * 这个字段比较特殊,因为历史原因在getActivitiesWithMultiLanguage需要返回map,在getActivityDefinition需要返回string
     */
    private Object activityName;

    /**
     * 提交签核任务的任务【task表】code
     */
    private Object startApproveActivity;
    /**
     * 提交签核任务的任务【task表】name
     */
    private String startApproveActivityName;
    /**
     * 不需要配置，通过startApproveActivity来做计算表示当前发起签核的任务所对应的签核任务code
     */
    private String targetApproveActivity;
    /**
     * 输入数据
     */
    private Object inputData;
    /**
     * 版本号
     */
    private String versionNumber;
    /**
     * 别名
     */
    private String nameAlias;
    /**
     * 监听器
     */
    private Map<String, Object> listener;

    /**
     * 评价模型code
     */
    private String evlModelCode;

    /**
     * 对应设计器流程设定的表单信息
     */
    private Map<String, Object> bindForm;
    /**
     * 字段权限，从task表中获取
     */
    private Object fieldConfig;
    /**
     * 后台任务,不对外展示
     */
    private Boolean daemon;
    /**
     * 是否需要发起租户级任务卡侦测
     */
    private Boolean needScheduledTaskDetail;
    /**
     * 自定义水印
     */
    private Boolean customizePageWatermark;
    public List<String> getFrom() {
        if (CollectionUtils.isEmpty(from) && null != stateMaps) {
            from = new ArrayList<>();
            stateMaps.forEach(sm -> {
                from.add(sm.getInput());
            });
        }
        return from;
    }

    public List<String> getTo() {
        if(CollectionUtils.isEmpty(to) && null!=stateMaps){
            to = new ArrayList<>();
            stateMaps.forEach(sm->{
                sm.getOutput().forEach((key,value)->{
                    to.add(value);
                });
            });
        }
        return to;
    }


    /**
     * 是否使用轻量级侦测
     */
    private Boolean needLightDetection;
    /**
     * 项目code
     */
    private String projectCode;
    /**
     * 页面
     */
    @Transient
    private Map<String, Object> pages;
    /**
     * 租户级摘要配置
     */
    @Transient
    private TenantSummaryFieldsDto tenantSummaryFields;
    /**
     * 摘要配置
     */
    @Transient
    private List<Map<String, Object>> summaryFields;
    /**
     * 可选择的租户级摘要配置字段
     */
    @Transient
    private List<Map<String, Object>> canSelectedSummaryFields;
    /**
     * 已使用的租户级摘要配置字段
     */
    @Transient
    private Boolean usedTenantSummaryFields;
    /**
     * 租户级卡片标题配置
     */
    @Transient
    private TenantCardTitleDefinition tenantCardTitleDefinition;
    /**
     * 应用名称
     */
    @Transient
    private String appName;
    /**
     * 应用code
     */
    @Transient
    private String appCode;
    /**
     * 包含的租户
     */
    private List<String> inclusionTenant;
    /**
     * 数据转换规则
     */
    private List<DataTransRule> dataTransRules;
    /**
     * 客制页面是否接入了加密
     */
    private Boolean customizePageEncrypted;
    /**
     * 驱动类型
     */
    private String driveType;
    /**
     * 任务是否允许跳过
     */
    private Boolean customCanSkip;
    /**
     * 是否开启特定业务场景
     */
    private Boolean customGroupSkip;

    /**
     * 业务流任务是否跳过
     */
    private Boolean customSkip;
    /**
     * 业务流自定义配置
     */
    private List<CustGroupSkipCondition> customSkipConditions;

    /**
     * 流程id
     */
    private String processId;

    /**
     * 拓展信息
     */
    private Map<String, Object> extendFields;

    /**
     * 条件分派
     */
    private List<ConditionalAssignment> conditionalAssignment;

    /**
     * 应用类型，数据驱动（1.0）：1，模型驱动（2.0）：5
     */
    private Integer appType;

    /**
     * 批量签核配置
     */
    private List<Map<String, Object>> batchApproval;

    /**
     * 所属应用类型
     */
    private String adpType;

    /**
     * 大T跳过触发条件字段
     */
    private List<Map<String, Object>> customSkipCondition;
    /**
     * 启用交付设计器总开关
     */
    private Boolean allowInteractiveFlag;
    /**
     * 启用交付设计器子开关
     */
    private InteractiveAbleConfig interactiveAbleConfig;

    /**
     * 2.0签核策略
     */
    private Map<String, Object> strategyConfig;
    /**
     * 2.0核决签层级
     */
    private ProcessDecisionConfig decisionConfig;
    /**
     * 2.0项目任务时长
     */
    private PlanEndTimeDefinition planEndTime;
}