package com.digiwin.athena.kg.report.hz.model.sence;


import com.digiwin.athena.domain.common.BaseObject;
import com.digiwin.athena.kg.monitorRule.PullingParamDTO;
import com.digiwin.athena.kg.monitorRule.secondCalculate.QueryStepDTO;

import com.digiwin.athena.kg.report.hz.model.SceneDTO;
import com.digiwin.athena.kg.report.hz.model.pushMetadata.ActionExecutionParam;
import lombok.Data;
import org.springframework.data.neo4j.core.schema.Id;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @title: ReportScene
 * @author: linc
 * @date 2023/12/4 14:20
 * @version: 1.0
 */
@Data
public class ReportSceneDTO extends BaseObject {

    @Id
    private Long id;
    /**
     * 场景code
     */
    private String code;
    // 小AI展示使用show showType
//    private List<ReportShowDTO> show;
//    private List<ReportShowTypeDTO> showType;

    private Object show;
    private Object showType;

    // 已废弃使用actionRelation
    private List<ActionRelationDTO> actionRelation;
    private String sceneTitle;
    // scene转侦测的人时事地端等配置
    private SceneDTO scene;
    private String actionId;
    private String version;
    // 转侦测使用actionParamDefine和recast，提供给ADE引擎等使用
    private Map<String, List<PullingParamDTO>> actionParamDefine;
    private Map<String, List<QueryStepDTO>> recast;

    // 场景例句
    private List<String> intentions;
    // relatedIntention处理后将例句一起放进来给uiBot
    private String relatedIntentions;  // DAP翻译处理不了数组，改成字符串
    /**
     *
     */
    private List<RelatedIntentionDTO> relatedIntention;

    /**
     * 场景描述
     */
    private String description;

    /**
     * 为了解决显示图表缺少维度的问题：
     * 查询出数据后，需要依据一些定义，明确按照哪个字段补全数据。
     * 定义：
     * 需要补充的维度、需要计算填补的字段
     */
    List<IncrementalPatch> incrementalPatch;
    /**
     * 是否使用转侦测
     */
    private Boolean useRecast;
    /**
     * 目标id
     */
    private String targetId;
    /**
     * 目标name
     */
    private String targetName;

    /**
     * 模板code
     */
    private String templateCode;
    /**
     * 模板名称
     */
    private String templateName;
    /**
     * 维度，后续废弃，使用actionDimension
     */
    private List<String> dimension;
    /**
     * 应用code
     */
    private String appCode;
    /**
     * 场景状态
     */
    private String status;
    /**
     * action 执行入参
     */
    private List<ActionExecutionParam> actionExecutionParam;
    /**
     * action 维度
     */
    private List<ActionDimension> actionDimension;

    /**
     * bmd 业务中台，dcp 边缘数据中台
     */
    private String dataSource = "dcp";
    /**
     * 产品
     */
    private List<ReportSceneProductDTO> products;
    /**
     * 应用计费商品id
     */
    private String billingGoodsId;
    /**
     * 视图类型
     */
    private String viewType;

    /**
     * 大屏刷新周期 分钟
     */
    private Integer flashFrequency;

    /**
     * 数据流刷新频率
     */
    private Integer dataFlowFrequency;

    /**
     * 板块刷新频率
     */
    private Integer pageTurningFrequency;
    /**
     * 指标产品线
     */
    private String prod;
    /**
     * 指标业务类型
     */
    private BusinessTypeDTO businessType;
    /**
     * 指标公式
     */
    private String formula;
    /**
     * 指标字段定义
     */
    private List<Object> fieldSchema;
    /**
     * 指标产品线
     */
    private List<String> productLine = Collections.singletonList("ERP");
    /**
     * 分类信息
     */
    private Map<String, Object> classification;
    /**
     * 布局id
     */
    private String layoutId;
    /**
     * 业务主键id
     */
    private List<Object> bkInfo;
}