package com.digiwin.athena.set.part;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @title: ConditionItem
 * @author: linc
 * @date 2023/10/14 16:34
 * @version: 1.0
 */
@Data
public class ConditionItem {
    private String type;

    private List<ConditionItem> items;

    private String leftField;

    private String op;

    private String rightField;

    public String toJavaScriptExpression() {
        if (!CollectionUtils.isEmpty(items)) {
            StringBuilder groupExpression = new StringBuilder();
            groupExpression.append("(");

            for (int i = 0; i < items.size(); i++) {
                ConditionItem item = items.get(i);
                String itemExpression = item.toJavaScriptExpression();
                groupExpression.append(itemExpression);

                if (i < items.size() - 1) {
                    groupExpression.append(" && ");
                }
            }

            groupExpression.append(")");

            return groupExpression.toString();
        } else {
            return operator();
        }
    }

    public String operator() {
        String operator;
        switch (op) {
            case "Equals":
                operator = "==";
                break;
            case "NotEqual":
                operator = "!=";
                break;
            case "Greater":
                operator = ">";
                break;
            case "Less":
                operator = "<";
                break;
            case "GreaterThanEqual":
                operator = ">=";
                break;
            case "LessThanEqual":
                operator = "<=";
                break;
            case "Include":
                return String.format("%s.indexOf(%s) !== -1", "data." + leftField + ".toString()", "data." + rightField + ".toString()");
            case "NotInclude":
                return String.format("%s.indexOf(%s) === -1", "data." + leftField + ".toString()", "data." + rightField + ".toString()");
            default:
                throw new IllegalArgumentException("Unsupported operator: " + op);
        }

        return String.format("(%s %s %s)", "data." + leftField, operator, "data." + rightField);
    }

}
