package com.digiwin.athena.dto;


import com.digiwin.athena.domain.core.Task;
import lombok.Data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-05-13 15:29
 **/
@Data
public class TaskPathVo implements Comparable<TaskPathVo>{
    /**
     * 任务集合
     */
    private List<Task> tasks = new ArrayList<>();

    @Deprecated
    private List<Task> firstTasks = new ArrayList<>();
    /**
     * 任务
     */
    private Task task;
    /**
     * 优先级
     */
    private Integer priority=0;
    /**
     * 消耗时间
     */
    private Long spendTime=0L;

    private Set<String> parsedStates= new HashSet<>();
    /**
     * 路径知否可执行
     */
    private boolean pathAvailable=true;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 租户版本
     */
    private String version;


    @Override
    public int compareTo(TaskPathVo o) {
        return   o.getPriority()-this.getPriority();
    }



}
