package com.digiwin.athena.kg.activity;

import com.digiwin.athena.kg.domain.CodedEntity;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

@Data
@Document(collection = "activityConfigs")
public class ActivityConfig extends CodedEntity {


    private String title;

    private String subTitle;

    private String description;

    private String subDescription;

    private Boolean multipleSelect;

    //json 获取数据action
    private Map<String, Object> getDataAction;
    //json 相关查询action  可能包含getDataAction
    private List<Map<String, Object>> relationQueries;
    //json 提交数据action
    private List<Map<String, Object>> submitActions;
    //json
    private List<Map<String, Object>> summaryFields;
    //json 保存过滤按钮
    private List<Map<String, Object>> filters;
    //json 操作相关
    private List<Map<String, Object>> operations;

    private List<Map<String, Object>> groupFields;

    private Map<String, Object> getTaskData;

    private List<Map<String, Object>> checkItems;

    private Map<String, Object> reason;

    private Map<String, Object> getFormulaAction;

    private Map<String, Object> countItems;

    //0901新版本json定义
    //数据源
    private Map<String, Object> dataSources;

    //数据查询器
    private List<Map<String, Object>> dataFilters;

    //数据加工器
    private List<Map<String, Object>> dataProcessors;

    //页面
    private Map<String, Object> pages;

    //审核相关
    private List<ActivityApprove> approves;

    //消息
    private List<Message> messages;

    //指定结束日期
    private ExpectedDurationDTO expectedDuration;

    //附件
    private Map<String, Object> attachment;

    private Map<String, Object> activityParameter;

    //任务关联的项目定义
    private List<Map<String, Object>> relatedTasks;

    // 任务名称
    private String name;


    private String copyApi;

    private List<String> executeType;
    private String product;

    /**
     * 应用 code
     */
    private String application;
}