package com.digiwin.athena.mechanism.bo;



import com.digiwin.athena.config.ApiParamDescription;
import com.digiwin.athena.domain.common.BaseObject;
import com.digiwin.athena.domain.definition.FieldDescription;
import lombok.Data;

import java.util.Date;
import java.util.List;
import java.util.Map;


@Data
public class MechanismBO extends BaseObject {


    private String code;
    private String name;
    //机制描述说明
    private String description;
    private String author;
    private Date createTime;

    //执行时的机制描述说明
    private String executeDescription;

    //支持的erp产品 如E10 WFGP
    private String[] supportProducts;

    //需要的数据结构
    private FieldDescription requireDataFrame;

    //需要的参数
    private List<FieldDescription> paramDescription;


    private boolean skipSimulate;

    //是否已设定
    private String defaultPageTemplate;

    //默认的实现类
    private String defaultPresent;


    //是否是组合机制
    private Boolean composite;

    private List<MechanismBO> subMechanisms;

    private boolean hasSet;

    private List<Map> enhance;

    /**
     * 模拟结果回写接口定义
     */
    private List<ApiParamDescription> simulateResultWriteBack;

    /**
     * 是否跳过输出文档
     */
    private boolean skipOutputFile;

    /**
     * 机制的原理定义
     */
    private List<PrincipleBO> principles;

    private List<Map> extensions;

    private String version;

    private String paradigmCode;

    //依赖的机制
    private List<String> dependMechanismCodes;
    //记录机制系统是否存在原理信息，用于区分是租户删除了所有原理的还是原来原理就不存在
    private Boolean existsSystemPrinciples;
}
