package com.digiwin.athena.domain.core;

import com.digiwin.athena.domain.core.dtdflow.Asserts;
import com.digiwin.athena.domain.core.process.InteractiveAbleConfig;
import com.digiwin.athena.domain.core.process.PlanEndTimeDefinition;
import com.digiwin.athena.domain.customBizTask.CustGroupSkipCondition;
import com.digiwin.athena.domain.definition.*;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.domain.definition.times.DueDateTimeDistance;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

@Getter
@Setter
public class Project extends Execution {

    /**
     * 项目起始状态
     */
    private DataState init;
    /**
     * 目标状态
     */
    private DataState end;
    /**
     * 其他非目标结束点
     */
    private List<DataState> ends;
    /**
     * 当责者
     */
    private UserDefinition personInCharge;
    /**
     * 项目知会人
     */
    private UserDefinition notifyParty;
    /**
     * 执行类型 mainline user solve
     */
    private String executeType;
    /**
     * 项目排序
     */
    private Integer sequence;
    /**
     *
     */
    private List<Project> userProjects;

    /**
     * 项目类型 BUSINESS FEEDBACK REPORT MECHANISM 需要兼容到
     */
    private String type;
    /**
     * 预计完成日实例对象
     */
    private DueDateTimeDistance dueDateTimeDistance;
    /**
     * 完成日实例对象
     */
    private DueDateTimeDistance dateTimeDistance;

    /**
     * 参见ActivityPatternEnum:  NONE,BUSINESS,ADJUSTMENT,MECHANISM;
     */
    private String pattern;
    /**
     * 是否支持手动发起
     */
    private Boolean manualAble;
    /**
     * 是否支持项目合并 值为null时合并
     */
    private Boolean merge;
    /**
     * 来源名称
     */
    private Object sourceName;
    /**
     * 预计完成日
     */
    private Object dueDateName;
    /**
     * 来源实体名称
     */
    private String sourceEntityName;
    /**
     * 获取来源单据详细数据的API
     */
    private Action sourceDetailAction;
    /**
     * 合并字段名数组
     */
    private List<String> mergeFields;
    /**
     * 转派人
     */
    private UserDefinition assignTo;
    /**
     * 是否转派
     */
    private Boolean assignAble;
    /**
     * 转派配置信息
     */
    private AssignConfig assignConfig;
    /**
     * 其他关联人
     */
    private UserDefinition relatedUsers;

    /**
     * pageView表code，需设计
     */
    private String pageCode;
    /**
     * 项目下任务【task表】code集合
     */
    @Deprecated
    private List<String> mainLineTasks;
    /**
     * 父项目编号。mainline项目下可以再建立user|solve子项目
     */
    @Deprecated
    private String primaryProjectCode;

    /**
     * 后台项目,不对外展示
     */
    @Deprecated
    private Boolean daemon;
    /**
     * 里程碑详情。包含里程碑名称，选中的task，排序
     */
    private List<Phase> phases;

    /**
     * 是否支持自定义项目时长
     */
    private Boolean supportCustomTimeDuration;
    /**
     * 自定义项目时长
     */
    private Integer timeDuration;

    /**
     * 当责者
     */
    private UserDefinition chargePerson;
    /**
     * 任务id
     */
    private String taskId;
    /**
     * 任务名称
     */
    private Object taskName;
    /**
     * 项目目标
     */
    private ProjectTarget target;
    /**
     * 项目的输入数据
     */
    private Object inputData;
    /**
     * 权限前缀
     */
    private String authorityPrefix;


    private Integer phasesHideKey;
    /**
     * 是否自定义页面水印
     */
    private Boolean customizePageWatermark;
    /**
     * 业务流自定义跳过配置
     */
    private CustomSkipConfig customSkipConfig;
    /**
     * 业务流是否支持自定义
     */
    private Boolean taskCanCustom;
    /**
     * 资产信息
     */
    private Asserts asserts;
    /**
     * 条件分派
     */
    private List<ConditionalAssignment> conditionalAssignment;
    /**
     * 启用交付设计器总开关
     */
    private Boolean allowInteractiveFlag;
    /**
     * 启用交付设计器子开关
     */
    private InteractiveAbleConfig interactiveAbleConfig;
    /**
     * 2.0项目任务时长
     */
    private PlanEndTimeDefinition planEndTime;

}
