/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kg.monitorRule;

import com.digiwin.athena.kg.monitorRule.StandardPollingRule;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class StandardPollingRuleDesign {
    static Map<String, String> week = new HashMap<String, String>();
    private String startTime;
    private String timeType;
    private String timeValue;
    private String interval;
    private Integer startTimeType;
    private String startVariableCode;

    public StandardPollingRule toStandardPollingRule() {
        StandardPollingRule standardPollingRule = new StandardPollingRule();
        String startTime = this.startTime;
        switch (this.timeType) {
            case "month": {
                standardPollingRule.setMonthly(1);
                String[] timevalues1 = this.timeValue.split(";");
                standardPollingRule.setBymonthday(Integer.parseInt(timevalues1[0]));
                startTime = startTime + " " + timevalues1[1] + ":00";
                break;
            }
            case "week": {
                standardPollingRule.setWeekly(1);
                String[] timevalues2 = this.timeValue.split(";");
                standardPollingRule.setByday(week.get(timevalues2[0]));
                startTime = startTime + " " + timevalues2[1] + ":00";
                break;
            }
            case "day": {
                standardPollingRule.setRepeat_type(3);
                standardPollingRule.setFrequency(1);
                startTime = startTime + " " + this.timeValue + ":00";
                break;
            }
            case "hour": {
                standardPollingRule.setRepeat_type(2);
                standardPollingRule.setFrequency((int)Double.parseDouble(this.timeValue));
                startTime = startTime + " 00:00:00";
                break;
            }
            case "minute": {
                standardPollingRule.setRepeat_type(1);
                standardPollingRule.setFrequency((int)Double.parseDouble(this.timeValue));
                startTime = startTime + " 00:00:00";
                break;
            }
            case "fixInterval": {
                if (!this.isLegalInterval(this.interval)) {
                    this.interval = "day";
                }
                switch (this.interval) {
                    case "day": {
                        String hourTime;
                        String repeatFrequency = "1";
                        if (this.isLegalTimeValue(this.timeValue)) {
                            hourTime = this.timeValue.split(";")[1];
                            repeatFrequency = this.timeValue.split(";")[0];
                        } else {
                            hourTime = this.timeValue;
                        }
                        standardPollingRule.setRepeat_type(3);
                        standardPollingRule.setFrequency(Integer.parseInt(repeatFrequency));
                        startTime = startTime + " " + hourTime + ":00";
                    }
                }
            }
        }
        if (!StringUtils.isEmpty((Object)this.startTimeType)) {
            standardPollingRule.setStartTimeType(this.startTimeType);
        }
        if (!StringUtils.isEmpty((Object)this.startVariableCode)) {
            standardPollingRule.setStartVariableCode(this.startVariableCode);
        }
        standardPollingRule.setStart_time(startTime);
        return standardPollingRule;
    }

    private boolean isLegalTimeValue(String timeValue) {
        return true;
    }

    private boolean isLegalInterval(String interval) {
        if (StringUtils.isEmpty((Object)interval)) {
            return false;
        }
        return interval.equals("day");
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getTimeType() {
        return this.timeType;
    }

    public String getTimeValue() {
        return this.timeValue;
    }

    public String getInterval() {
        return this.interval;
    }

    public Integer getStartTimeType() {
        return this.startTimeType;
    }

    public String getStartVariableCode() {
        return this.startVariableCode;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setTimeType(String timeType) {
        this.timeType = timeType;
    }

    public void setTimeValue(String timeValue) {
        this.timeValue = timeValue;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public void setStartTimeType(Integer startTimeType) {
        this.startTimeType = startTimeType;
    }

    public void setStartVariableCode(String startVariableCode) {
        this.startVariableCode = startVariableCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardPollingRuleDesign)) {
            return false;
        }
        StandardPollingRuleDesign other = (StandardPollingRuleDesign)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$startTimeType = this.getStartTimeType();
        Integer other$startTimeType = other.getStartTimeType();
        if (this$startTimeType == null ? other$startTimeType != null : !((Object)this$startTimeType).equals(other$startTimeType)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$timeType = this.getTimeType();
        String other$timeType = other.getTimeType();
        if (this$timeType == null ? other$timeType != null : !this$timeType.equals(other$timeType)) {
            return false;
        }
        String this$timeValue = this.getTimeValue();
        String other$timeValue = other.getTimeValue();
        if (this$timeValue == null ? other$timeValue != null : !this$timeValue.equals(other$timeValue)) {
            return false;
        }
        String this$interval = this.getInterval();
        String other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
            return false;
        }
        String this$startVariableCode = this.getStartVariableCode();
        String other$startVariableCode = other.getStartVariableCode();
        return !(this$startVariableCode == null ? other$startVariableCode != null : !this$startVariableCode.equals(other$startVariableCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StandardPollingRuleDesign;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $startTimeType = this.getStartTimeType();
        result = result * 59 + ($startTimeType == null ? 43 : ((Object)$startTimeType).hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $timeType = this.getTimeType();
        result = result * 59 + ($timeType == null ? 43 : $timeType.hashCode());
        String $timeValue = this.getTimeValue();
        result = result * 59 + ($timeValue == null ? 43 : $timeValue.hashCode());
        String $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        String $startVariableCode = this.getStartVariableCode();
        result = result * 59 + ($startVariableCode == null ? 43 : $startVariableCode.hashCode());
        return result;
    }

    public String toString() {
        return "StandardPollingRuleDesign(startTime=" + this.getStartTime() + ", timeType=" + this.getTimeType() + ", timeValue=" + this.getTimeValue() + ", interval=" + this.getInterval() + ", startTimeType=" + this.getStartTimeType() + ", startVariableCode=" + this.getStartVariableCode() + ")";
    }

    static {
        week.put("0", "SU");
        week.put("1", "MO");
        week.put("2", "TU");
        week.put("3", "WE");
        week.put("4", "TH");
        week.put("5", "FR");
        week.put("6", "SA");
    }
}

